//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "UploadQueue.h"
#include "Packets.h"
#include "KnownFile.h"
#include "ListenSocket.h"
#include "Exceptions.h"
#include "Scheduler.h"
#include "PerfLog.h"
#include "UploadBandwidthThrottler.h"
#include "ClientList.h"
#include "LastCommonRouteFinder.h"
#include "DownloadQueue.h"
#include "FriendList.h"
#include "Statistics.h"
#include "MMServer.h"
#include "OtherFunctions.h"
#include "UpDownClient.h"
#include "SharedFileList.h"
#include "KnownFileList.h"
#include "Sockets.h"
#include "ClientCredits.h"
#include "Server.h"
#include "ServerList.h"
#include "WebServer.h"
#include "emuledlg.h"
#include "ServerWnd.h"
#include "TransferWnd.h"
#include "SearchDlg.h"
#include "StatisticsDlg.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/Kademlia/Prefs.h"
#include "Log.h"
#include "collection.h"
//#include <Math.h> //>>> Spike2::L2HAC [enkeyDEV]
#include "EMF/Argos/Argos.h" //==> dlarge Argos System (Xanatos)

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//>>> WiZaRd::Automatic Firewalled Retries
static uint8 m_iFirewalledRetries = 0;
static	DWORD	m_dwFirewalledTimer = NULL;
//<<< WiZaRd::Automatic Firewalled Retries

static uint32 counter, sec, statsave;
static UINT _uSaveStatistics = 0;
// -khaos--+++> Added iupdateconnstats...
static uint32 igraph, istats, iupdateconnstats;
// <-----khaos-


CUploadQueue::CUploadQueue()
{
	m_uiPaybackCount = 0; //>>> WiZaRd::Payback First
	m_dwFirewalledTimer = ::GetTickCount(); //>>> WiZaRd::Automatic Firewalled Retries 
	VERIFY( (h_timer = SetTimer(0,0,100,UploadTimer)) != NULL );
	if (thePrefs.GetVerbose() && !h_timer)
		AddDebugLogLine(true,_T("Failed to create 'upload queue' timer - %s"),GetErrorMessage(GetLastError()));
	datarate = 0;
	counter=0;
	successfullupcount = 0;
	failedupcount = 0;
	totaluploadtime = 0;
	m_nLastStartUpload = 0;
	statsave=0;
	// -khaos--+++>
	iupdateconnstats=0;
	// <-----khaos-
	m_dwRemovedClientByScore = ::GetTickCount();
    m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = 0;
    m_MaxActiveClients = 0;
    m_MaxActiveClientsShortTime = 0;

    m_lastCalculatedDataRateTick = 0;
    m_avarage_dr_sum = 0;
    friendDatarate = 0;

    m_dwLastResortedUploadSlots = 0;

//==> dlarge SUC/USS
	AvgRespondTime[0]=500;
	AvgRespondTime[1]=thePrefs.GetSUCPitch()/2;//Changed by Yun.SF3 (this is too much divided, original is 3)
	MaxVUR=512*(thePrefs.GetMaxUpload()+thePrefs.GetMinUpload()); //When we start with SUC take the middle range for upload
//<== dlarge SUC/USS
}

//>>> WiZaRd::Payback First
INT64	GetUpDownDiff(const CUpDownClient* client)
{
	if(client->Credits() == NULL)
		return _I64_MIN;
	return  client->Credits()->GetDownloadedTotal()-client->Credits()->GetUploadedTotal();
}

BOOL IsPayback(const CUpDownClient* client)
{	
	return (!client->GetRequestFile() || client->GetDownloadState() > DS_ONQUEUE)
		&& GetUpDownDiff(client) > (SESSIONMAXTRANS/2);
}

BOOL SecondIsBetterClient(const bool bPaybackCheck, const CUpDownClient* first, const CUpDownClient* second, const UINT firstscore, const UINT secondscore)
{
	if(second == NULL)
		return FALSE;
	if(first == NULL)
		return TRUE;

	if(bPaybackCheck)
	{
		const BOOL bPay1 = IsPayback(first);
		const BOOL bPay2 = IsPayback(second);
		if(bPay1 && !bPay2)
			return FALSE;	//first is better
		if(!bPay1 && bPay2)
			return TRUE;	//second is better
		else if(bPay1 && bPay2) 
			return GetUpDownDiff(second) > GetUpDownDiff(first); //second or first?
		//flow over
	}

	return (secondscore > firstscore);
}
//<<< WiZaRd::Payback First

/**
 * Find the highest ranking client in the waiting queue, and return it.
 *
 * Low id client are ranked as lowest possible, unless they are currently connected.
 * A low id client that is not connected, but would have been ranked highest if it
 * had been connected, gets a flag set. This flag means that the client should be
 * allowed to get an upload slot immediately once it connects.
 *
 * @return address of the highest ranking client.
 */
CUpDownClient* CUploadQueue::FindBestClientInQueue()
{
//>>> WiZaRd::Optimization
	//while I'm at it I cleaned this up a bit...
	//just to mention it... the official client has a bug here
	//we will search for a client with score > 0... now IF the extreme rare case
	//happens that we have only GPL breakers in queue then NOONE will ever be added...
	uint32	bestscore = 0;
	uint32  bestlowscore = 0;
	CUpDownClient* newclient = NULL;
	CUpDownClient* lowclient = NULL;

//>>> WiZaRd::PowerShare
	CUpDownClient* friendclient = NULL;
	uint32	bestscorePS = 0;
	uint32  bestlowscorePS = 0;
	CUpDownClient* newclientPS = NULL;
	CUpDownClient* lowclientPS = NULL;
//<<< WiZaRd::PowerShare
//>>> WiZaRd::Payback First
	bool bPaybackCheck = false; 
	switch(thePrefs.GetPaybackFirst())
	{
		default:
		case 0: //off
			break;

		case 1: //on - one slot
			bPaybackCheck = m_lPaybackList.IsEmpty() ? true : false;
			break;

		case 2: //on - once every X slots
			bPaybackCheck = m_uiPaybackCount == 5;
			break;

		case 3: //auto - TODO?
			bPaybackCheck = m_lPaybackList.IsEmpty()
				|| m_uiPaybackCount == 5;
			break;
	}
//<<< WiZaRd::Payback First

	for (POSITION pos1 = waitinglist.GetHeadPosition(); pos1 != NULL;)
	{
		POSITION pos2 = pos1;
		CUpDownClient* cur_client =	waitinglist.GetNext(pos1);
		CKnownFile* file = theApp.sharedfiles->GetFileByID(cur_client->GetUploadFileID());
		//While we are going through this list.. Lets check if a client appears to have left the network..
		ASSERT ( cur_client->GetLastUpRequest() );
//>>> WiZaRd::FiX unfair client treatment [http://forum.emule-project.net/index.php?showtopic=116699]
		//if ((::GetTickCount() - cur_client->GetLastUpRequest() > MAX_PURGEQUEUETIME) || !file )
		if ((::GetTickCount() - cur_client->GetLastUpRequest() > MAX_PURGEQUEUETIME))
//<<< WiZaRd::FiX unfair client treatment [http://forum.emule-project.net/index.php?showtopic=116699]
		{
			//This client has either not been seen in a long time, or we no longer share the file he wanted anymore..
			cur_client->ClearWaitStartTime();
                        cur_client->m_bUpIsProblematic = false; //==> dlarge UploadingProblemClient (Xman)
			RemoveFromWaitingQueue(pos2,true);
			continue;
		}
//>>> WiZaRd::FiX unfair client treatment [http://forum.emule-project.net/index.php?showtopic=116699]
		if(file == NULL)
			continue;
//<<< WiZaRd::FiX unfair client treatment [http://forum.emule-project.net/index.php?showtopic=116699]
//>>> WiZaRd::Startup Flood Prevention
		//Requested by James R. Bath
		//http://forum.emule-project.net/index.php?showtopic=101181
		if(::GetTickCount() - cur_client->GetWaitStartTime() < SEC2MS(30)) //30secs are enough
			continue;
//<<< WiZaRd::Startup Flood Prevention
//>>> WiZaRd::PowerShare
		if(cur_client->GetFriendSlot())
			friendclient = cur_client;
		if(friendclient)
			continue;
//<<< WiZaRd::PowerShare
		// finished clearing
		const uint32 cur_score = cur_client->GetScore(false);

//>>> WiZaRd::PowerShare
		if(file->IsPowerShared())
		{
//>>> WiZaRd::Payback First
			if(SecondIsBetterClient(bPaybackCheck, newclientPS, cur_client, bestscorePS, cur_score))
			//if (cur_score > bestscorePS)
//<<< WiZaRd::Payback First
			{
				// cur_client is more worthy than current best client that is ready to go (connected).
				if(!cur_client->HasLowID() 
                                && (!cur_client->m_bUpIsProblematic) //==> dlarge UploadingProblemClient (Xman)
                                || (cur_client->socket && cur_client->socket->IsConnected())) 
				{
					// this client is a HighID or a lowID client that is ready to go (connected)
					// and it is more worthy
					bestscorePS = cur_score;
					newclientPS = cur_client;
				} 
				else if(!cur_client->m_bAddNextConnect) 
				{
					// this client is a lowID client that is not ready to go (not connected)

					// now that we know this client is not ready to go, compare it to the best not ready client
					// the best not ready client may be better than the best ready client, so we need to check
					// against that client
//>>> WiZaRd::Payback First
					if(SecondIsBetterClient(bPaybackCheck, lowclientPS, cur_client, bestlowscorePS, cur_score))
					//if (cur_score > bestlowscorePS)
//<<< WiZaRd::Payback First
					{
						// it is more worthy, keep it
						bestlowscorePS = cur_score;
						lowclientPS = cur_client;
					}
				}
			} 
		}
		else
//<<< WiZaRd::PowerShare
		{
//>>> WiZaRd::Payback First
			if(SecondIsBetterClient(bPaybackCheck, newclient, cur_client, bestscore, cur_score))
			//if (cur_score > bestscore)
//<<< WiZaRd::Payback First
			{
				// cur_client is more worthy than current best client that is ready to go (connected).
				if((!cur_client->HasLowID() 
					&& !cur_client->m_bUpIsProblematic) //==> dlarge UploadingProblemClient (Xman)
					|| (cur_client->socket && cur_client->socket->IsConnected())) {
					// this client is a HighID or a lowID client that is ready to go (connected)
					// and it is more worthy
					bestscore = cur_score;
					newclient = cur_client;
				} 
				else if(!cur_client->m_bAddNextConnect) 
				{
					// this client is a lowID client that is not ready to go (not connected)

					// now that we know this client is not ready to go, compare it to the best not ready client
					// the best not ready client may be better than the best ready client, so we need to check
					// against that client
//>>> WiZaRd::Payback First
					if(SecondIsBetterClient(bPaybackCheck, lowclient, cur_client, bestlowscore, cur_score))
					//if (cur_score > bestlowscore)
//<<< WiZaRd::Payback First
					{
						// it is more worthy, keep it
						bestlowscore = cur_score;
						lowclient = cur_client;
					}
				}
			}
		} 
	}

//>>> WiZaRd::PowerShare
//>>> WiZaRd::Payback First
	if(lowclientPS && SecondIsBetterClient(bPaybackCheck, newclientPS, lowclientPS, bestscorePS, bestlowscorePS))
	//if (bestlowscorePS > bestscorePS && lowclientPS)
//<<< WiZaRd::Payback First
		lowclientPS->m_bAddNextConnect = true;
	else
//<<< WiZaRd::PowerShare
//>>> WiZaRd::Payback First
	if(lowclient && SecondIsBetterClient(bPaybackCheck, newclient, lowclient, bestscore, bestlowscore))
	//if (bestlowscore > bestscore && lowclient)
//<<< WiZaRd::Payback First
		lowclient->m_bAddNextConnect = true;

//>>> WiZaRd::PowerShare
	if(friendclient)
		return friendclient;
	if(newclientPS)
		return newclientPS;
//<<< WiZaRd::PowerShare
	return newclient;
}

void CUploadQueue::InsertInUploadingList(CUpDownClient* newclient) 
{
//>>> WiZaRd::Payback First
	if(IsPayback(newclient))
		m_lPaybackList.AddTail(newclient); 
//<<< WiZaRd::Payback First
	//Lets make sure any client that is added to the list has this flag reset!
	newclient->m_bAddNextConnect = false;
    // Add it last
    theApp.uploadBandwidthThrottler->AddToStandardList(uploadinglist.GetCount(), newclient->GetFileUploadSocket());
	uploadinglist.AddTail(newclient);
    newclient->SetSlotNumber(uploadinglist.GetCount());
}

bool CUploadQueue::AddUpNextClient(LPCTSTR pszReason, CUpDownClient* directadd){
	CUpDownClient* newclient = NULL;
	// select next client or use given client
	if (!directadd)
	{
        newclient = FindBestClientInQueue();

        if(newclient)
		{
		    RemoveFromWaitingQueue(newclient, true);
		    //theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
			theApp.emuledlg->transferwnd->ShowQueueCount();
        }
	}
	else 
		newclient = directadd;

    if(newclient == NULL) 
        return false;

//==> dlarge Argos System (Xanatos)
	if(newclient->IsBanned()) // never add banned clients!
		return false;
//<== dlarge Argos System (Xanatos)
	
// VQB: fullChunk
	/*
	if (!thePrefs.TransferFullChunks())
		UpdateMaxClientScore(); // refresh score caching, now that the highest score is removed
	*/
// VQB: fullChunk

	if (IsDownloading(newclient))
		return false;

    if(pszReason && thePrefs.GetLogUlDlEvents())
        AddDebugLogLine(false, _T("Adding client to upload list: %s Client: %s File: %s"), pszReason, newclient->DbgGetClientInfo(), (theApp.sharedfiles->GetFileByID(newclient->GetUploadFileID())?theApp.sharedfiles->GetFileByID(newclient->GetUploadFileID())->GetFileName():_T(""))); //==> dlarge Optimation

	if (newclient->HasCollectionUploadSlot() && directadd == NULL){
		ASSERT( false );
		newclient->SetCollectionUploadSlot(false);
	}

	// tell the client that we are now ready to upload
//==> dlarge Hello-Handshake fix (Sirob)
	if (!newclient->socket || !newclient->socket->IsConnected() || !newclient->CheckHandshakeFinished())
//<== dlarge Hello-Handshake fix (Sirob)
	{
		newclient->SetUploadState(US_CONNECTING);
		if (!newclient->TryToConnect(true))
			return false;
	}
	else
	{
		if (thePrefs.GetDebugClientTCPLevel() > 0)
			DebugSend("OP__AcceptUploadReq", newclient);
		Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
		theStats.AddUpDataOverheadFileRequest(packet->size);
		newclient->socket->SendPacket(packet,true);
		newclient->SetUploadState(US_UPLOADING);
//==> dlarge find best sources (Xman)
		//in every case, we add this client to our downloadqueue
		CKnownFile* partfile = theApp.downloadqueue->GetFileByID(newclient->GetUploadFileID());
		if (partfile && partfile->IsPartFile())
			theApp.downloadqueue->CheckAndAddKnownSource((CPartFile*)partfile,newclient, true);
//<== dlarge find best sources (Xman)
	}
	newclient->SetUpStartTime();
	newclient->ResetSessionUp();
	newclient->ResetRemainingUp();	// VQB: fullChunk
        newclient->m_bUpIsProblematic = false; //==> dlarge UploadingProblemClient (Xman)
    InsertInUploadingList(newclient);

    m_nLastStartUpload = ::GetTickCount();
	
	// statistic
	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)newclient->GetUploadFileID());
	if (reqfile){
		reqfile->statistic.AddAccepted();
		newclient->SetUploadingFile(reqfile); //==> dlarge Argos System (Xanatos)
	}
		
	theApp.emuledlg->transferwnd->uploadlistctrl.AddClient(newclient);

	return true;
}

void CUploadQueue::UpdateActiveClientsInfo(DWORD curTick) {
    // Save number of active clients for statistics
    uint32 tempHighest = theApp.uploadBandwidthThrottler->GetHighestNumberOfFullyActivatedSlotsSinceLastCallAndReset();

    if(thePrefs.GetLogUlDlEvents() && theApp.uploadBandwidthThrottler->GetStandardListSize() > (uint32)uploadinglist.GetSize()) {
        // debug info, will remove this when I'm done.
        //AddDebugLogLine(false, _T("UploadQueue: Error! Throttler has more slots than UploadQueue! Throttler: %i UploadQueue: %i Tick: %i"), theApp.uploadBandwidthThrottler->GetStandardListSize(), uploadinglist.GetSize(), ::GetTickCount());

		if(tempHighest > (uint32)uploadinglist.GetSize()+1) {
        	tempHighest = uploadinglist.GetSize()+1;
		}
    }

    m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = tempHighest;

    // save some data about number of fully active clients
    uint32 tempMaxRemoved = 0;
    while(!activeClients_tick_list.IsEmpty() && !activeClients_list.IsEmpty() && curTick-activeClients_tick_list.GetHead() > 20*1000) {
        activeClients_tick_list.RemoveHead();
	    uint32 removed = activeClients_list.RemoveHead();

        if(removed > tempMaxRemoved) {
            tempMaxRemoved = removed;
        }
    }

	activeClients_list.AddTail(m_iHighestNumberOfFullyActivatedSlotsSinceLastCall);
    activeClients_tick_list.AddTail(curTick);

    if(activeClients_tick_list.GetSize() > 1) {
        uint32 tempMaxActiveClients = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        uint32 tempMaxActiveClientsShortTime = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        POSITION activeClientsTickPos = activeClients_tick_list.GetTailPosition();
        POSITION activeClientsListPos = activeClients_list.GetTailPosition();
        while(activeClientsListPos != NULL && (tempMaxRemoved > tempMaxActiveClients && tempMaxRemoved >= m_MaxActiveClients || curTick - activeClients_tick_list.GetAt(activeClientsTickPos) < 10 * 1000)) {
            DWORD activeClientsTickSnapshot = activeClients_tick_list.GetAt(activeClientsTickPos);
            uint32 activeClientsSnapshot = activeClients_list.GetAt(activeClientsListPos);

            if(activeClientsSnapshot > tempMaxActiveClients) {
                tempMaxActiveClients = activeClientsSnapshot;
            }

            if(activeClientsSnapshot > tempMaxActiveClientsShortTime && curTick - activeClientsTickSnapshot < 10 * 1000) {
                tempMaxActiveClientsShortTime = activeClientsSnapshot;
            }

            activeClients_tick_list.GetPrev(activeClientsTickPos);
            activeClients_list.GetPrev(activeClientsListPos);
        }

        if(tempMaxRemoved >= m_MaxActiveClients || tempMaxActiveClients > m_MaxActiveClients) {
            m_MaxActiveClients = tempMaxActiveClients;
        }

        m_MaxActiveClientsShortTime = tempMaxActiveClientsShortTime;
    } else {
        m_MaxActiveClients = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        m_MaxActiveClientsShortTime = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
    }
}

/**
 * Maintenance method for the uploading slots. It adds and removes clients to the
 * uploading list. It also makes sure that all the uploading slots' Sockets always have
 * enough packets in their queues, etc.
 *
 * This method is called approximately once every 100 milliseconds.
 */
//==> dlarge SlotControl
void CUploadQueue::Process() 
{

    DWORD curTick = ::GetTickCount();

    UpdateActiveClientsInfo(curTick);

	if (ForceNewClient()){
        // There's not enough open uploads. Open another one.
        AddUpNextClient(_T("Not enough open upload slots for current ul speed"));
	}
	else 
    {
        CUpDownClient* lastClient = NULL;
            POSITION lastpos = uploadinglist.GetTailPosition();

        if(lastpos != NULL) {
            lastClient = uploadinglist.GetAt(lastpos);
        }

        if(lastClient != NULL && !lastClient->IsScheduledForRemoval() && lastClient->GetUpStartTimeDelay() > 3*1000 )
        {
			if(	::GetTickCount()-m_nLastStartUpload > SEC2MS(20) && 
					GetEffectiveUploadListCount() > 0 &&
					uploadinglist.GetCount() - GetEffectiveUploadListCount() > GetWantedNumberOfTrickleUploads() &&
					AcceptNewClient(GetEffectiveUploadListCount()-1) == false
				)
			{
				ScheduleRemovalFromUploadQueue(lastClient, _T("Too many upload slots opened for current ul speed"), _T("Too many slots"), true );
        }
    } 
}
    // The loop that feeds the upload slots with data.
	POSITION pos = uploadinglist.GetHeadPosition();
	while(pos != NULL)
	{
        // Get the client. Note! Also updates pos as a side effect.
		CUpDownClient* cur_client = uploadinglist.GetNext(pos);
		if (thePrefs.m_iDbgHeap >= 2)
			ASSERT_VALID(cur_client);
		//It seems chatting or friend slots can get stuck at times in upload.. This needs looked into..
		if (!cur_client->socket)
		{
			RemoveFromUploadQueue(cur_client, _T("Uploading to client without socket? (CUploadQueue::Process)"));
			if(cur_client->Disconnected(_T("CUploadQueue::Process"))){
				delete cur_client;
			}
		} else {
		if(!cur_client->IsScheduledForRemoval() || ::GetTickCount()-m_nLastStartUpload <= SEC2MS(11) || !cur_client->GetScheduledRemovalLimboComplete() || pos != NULL || cur_client->GetSlotNumber() <= GetActiveUploadsCount() || ForceNewClient(true))
	       {
            cur_client->SendBlockData();
        }
			else
			{
				bool keepWaitingTime = true;
				RemoveFromUploadQueue(cur_client, (CString)_T("Scheduled for removal: ") + cur_client->GetScheduledRemovalDebugReason(), true, keepWaitingTime);
				AddClientToQueue(cur_client,keepWaitingTime,keepWaitingTime);
                m_nLastStartUpload = ::GetTickCount()-SEC2MS(9);
			}
		}
	}
//<== dlarge SlotControl

    // Save used bandwidth for speed calculations
	uint64 sentBytes = theApp.uploadBandwidthThrottler->GetNumberOfSentBytesSinceLastCallAndReset();
	avarage_dr_list.AddTail(sentBytes);
    m_avarage_dr_sum += sentBytes;

    (void)theApp.uploadBandwidthThrottler->GetNumberOfSentBytesOverheadSinceLastCallAndReset();

    avarage_friend_dr_list.AddTail(theStats.sessionSentBytesToFriend);

    // Save time between each speed snapshot
    avarage_tick_list.AddTail(curTick);

    // don't save more than 30 secs of data
    while(avarage_tick_list.GetCount() > 3 && !avarage_friend_dr_list.IsEmpty() && ::GetTickCount()-avarage_tick_list.GetHead() > 30*1000) {
   	    m_avarage_dr_sum -= avarage_dr_list.RemoveHead();
        avarage_friend_dr_list.RemoveHead();
        avarage_tick_list.RemoveHead();
    }
//>>> Spike2::L2HAC [enkeyDEV]
	static DWORD dwLastL2HACCheck = ::GetTickCount();
	if (theApp.IsFirewalled()
		&& curTick - dwLastL2HACCheck > MIN2MS(1)) //do not check TOO often... parsing the whole waitinglist is expensive!
	{
		dwLastL2HACCheck = curTick;
		for (POSITION pos = waitinglist.GetHeadPosition(); pos;)
		{
			CUpDownClient* cur_client = waitinglist.GetNext(pos);
			if (cur_client->IsL2HACEnabled()
				&& cur_client->GetLastL2HACExecution()
				//&& cur_client->GetL2HACTime() // this is already checked in AddClientToQueue
				&& (curTick - cur_client->GetLastL2HACExecution()) > cur_client->GetL2HACTime())
			{
				if (theApp.listensocket->TooManySockets() && !(cur_client->socket && cur_client->socket->IsConnected()) )
					cur_client->SetLastL2HACExecution(curTick - cur_client->GetL2HACTime() + (uint32)ROUND(((float)rand()/RAND_MAX)*300000));
				else
				{
					cur_client->EnableL2HAC(false);
					//if (!cur_client->HasLowID() && cur_client->GetL2HACTime()) // this is already checked in AddClientToQueue
					cur_client->TryToConnect();
				}
			}
		}
	}
//<<< Spike2::L2HAC [enkeyDEV]
};

bool CUploadQueue::AcceptNewClient(bool addOnNextConnect)
{
	uint32 curUploadSlots = (uint32)uploadinglist.GetCount();

	//We allow ONE extra slot to be created to accommodate lowID users.
	//This is because we skip these users when it was actually their turn
	//to get an upload slot..
	if(curUploadSlots == 0) //return true straight away
		return true;

	if(addOnNextConnect)
		--curUploadSlots;		

    return AcceptNewClient(curUploadSlots);
}

bool CUploadQueue::AcceptNewClient(uint32 curUploadSlots)
{
	// check if we can allow a new client to start downloading from us

    if ( curUploadSlots < MIN_UP_CLIENTS_ALLOWED ) 
		return true;

    uint16  MaxSpeed;
    if (thePrefs.IsDynUpEnabled())
        MaxSpeed = (uint16)(theApp.lastCommonRouteFinder->GetUpload()/1024);
    else
		MaxSpeed = thePrefs.GetMaxUpload();

//==> dlarge SlotControl
	if(thePrefs.IsSlotFocus() == false)
        {         
//<== dlarge SlotControl
	if (curUploadSlots >= MAX_UP_CLIENTS_ALLOWED ||
        curUploadSlots >= 4 &&
        (
         curUploadSlots >= (datarate/UPLOAD_CHECK_CLIENT_DR) ||
         curUploadSlots >= ((uint32)MaxSpeed)*1024/UPLOAD_CLIENT_DATARATE ||
         (
          thePrefs.GetMaxUpload() == UNLIMITED &&
          !thePrefs.IsDynUpEnabled() &&
          thePrefs.GetMaxGraphUploadRate(true) > 0 &&
          curUploadSlots >= ((uint32)thePrefs.GetMaxGraphUploadRate(false))*1024/UPLOAD_CLIENT_DATARATE
         )
        )
    ) // max number of clients to allow for all circumstances
		return false;

//==> dlarge SlotControl
	}	
	else
	{
		uint32 wantedNumberOfTrickles = GetWantedNumberOfTrickleUploads();
		if(curUploadSlots > m_MaxActiveClients+wantedNumberOfTrickles) {
			return false;
		}

		if (curUploadSlots >= 4 &&
			curUploadSlots >= (datarate/UPLOAD_CHECK_CLIENT_DR)
		) // max number of clients to allow for all circumstances
		return false;

	return true;
}
//<== dlarge SlotControl
	return true;
	}

bool CUploadQueue::ForceNewClient(bool allowEmptyWaitingQueue, bool simulateScheduledClosingOfSlot) {

//==> dlarge SlotControl
	if(thePrefs.IsSlotFocus() == false)
{
    if(!allowEmptyWaitingQueue && waitinglist.IsEmpty())
        return false;
//<== dlarge SlotControl
	if (::GetTickCount() - m_nLastStartUpload < 1000 && datarate < 102400 )
		return false;

	uint32 curUploadSlots = (uint32)uploadinglist.GetCount();

	if (curUploadSlots < MIN_UP_CLIENTS_ALLOWED)
		return true;

    if(!AcceptNewClient(curUploadSlots) || !theApp.lastCommonRouteFinder->AcceptNewClient()) { // UploadSpeedSense can veto a new slot if USS enabled
		return false;
                }
   
		uint16 MaxSpeed;
		if (thePrefs.IsDynUpEnabled())
        MaxSpeed = (uint16)(theApp.lastCommonRouteFinder->GetUpload()/1024);
		else
			MaxSpeed = thePrefs.GetMaxUpload();

	uint32 upPerClient = UPLOAD_CLIENT_DATARATE;

		// if throttler doesn't require another slot, go with a slightly more restrictive method
		if( MaxSpeed > 20 || MaxSpeed == UNLIMITED)
			upPerClient += datarate/43;

		if( upPerClient > 7680 )
			upPerClient = 7680;

		//now the final check

		if ( MaxSpeed == UNLIMITED )
{
			if (curUploadSlots < (datarate/upPerClient))
				return true;
		}
		else{
			UINT nMaxSlots;
			if (MaxSpeed > 12)
				nMaxSlots = (uint16)(((float)(MaxSpeed*1024)) / upPerClient);
			else if (MaxSpeed > 7)
				nMaxSlots = MIN_UP_CLIENTS_ALLOWED + 2;
			else if (MaxSpeed > 3)
				nMaxSlots = MIN_UP_CLIENTS_ALLOWED + 1;
			else
				nMaxSlots = MIN_UP_CLIENTS_ALLOWED;
	//		AddLogLine(true,"maxslots=%u, upPerClient=%u, datarateslot=%u|%u|%u",nMaxSlots,upPerClient,datarate/UPLOAD_CHECK_CLIENT_DR, datarate, UPLOAD_CHECK_CLIENT_DR);

			if ( curUploadSlots < nMaxSlots )
			{
				return true;
			}
		}

		if(m_iHighestNumberOfFullyActivatedSlotsSinceLastCall > (uint32)uploadinglist.GetSize()) {
			// uploadThrottler requests another slot. If throttler says it needs another slot, we will allow more slots
			// than what we require ourself. Never allow more slots than to give each slot high enough average transfer speed, though (checked above).
        //if(thePrefs.GetLogUlDlEvents() && waitinglist.GetSize() > 0)
        //    AddDebugLogLine(false, _T("UploadQueue: Added new slot since throttler needs it. m_iHighestNumberOfFullyActivatedSlotsSinceLastCall: %i uploadinglist.GetSize(): %i tick: %i"), m_iHighestNumberOfFullyActivatedSlotsSinceLastCall, uploadinglist.GetSize(), ::GetTickCount());
			return true;
		}

		//nope
		return false;
}

//==> dlarge SlotControl
	else
        {
		if (::GetTickCount() - m_nLastStartUpload < SEC2MS(1) && datarate < 102400 )
			return false;

		uint32 curUploadSlots = (uint32)GetEffectiveUploadListCount();
		uint32 curUploadSlotsReal = (uint32)uploadinglist.GetCount();

		if(simulateScheduledClosingOfSlot) {
			if(curUploadSlotsReal < 1) {
				return true;
			} else {
				curUploadSlotsReal--;
			}
		}

		if (curUploadSlots < MIN_UP_CLIENTS_ALLOWED)
			return true;

		if(!AcceptNewClient(curUploadSlots) || !theApp.lastCommonRouteFinder->AcceptNewClient()) { // UploadSpeedSense can veto a new slot if USS enabled
			return false;
		}

		uint32 activeSlots = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;

		if(simulateScheduledClosingOfSlot) {
			activeSlots = m_MaxActiveClientsShortTime;
		}

		if(curUploadSlotsReal < m_iHighestNumberOfFullyActivatedSlotsSinceLastCall /*+1*/ ||
		curUploadSlots < m_iHighestNumberOfFullyActivatedSlotsSinceLastCall+1 && ::GetTickCount() - m_nLastStartUpload > SEC2MS(10)) {
			return true;
		}

		//nope
		return false;
	}
}
//<== dlarge SlotControl
   
CUploadQueue::~CUploadQueue(){
	if (h_timer)
		KillTimer(0,h_timer);
}

CUpDownClient* CUploadQueue::GetWaitingClientByIP_UDP(uint32 dwIP, uint16 nUDPPort, bool bIgnorePortOnUniqueIP, bool* pbMultipleIPs){
	CUpDownClient* pMatchingIPClient = NULL;
	uint32 cMatches = 0;
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;){
		CUpDownClient* cur_client = waitinglist.GetNext(pos);
		if (dwIP == cur_client->GetIP() && nUDPPort == cur_client->GetUDPPort())
			return cur_client;
		else if (dwIP == cur_client->GetIP() && bIgnorePortOnUniqueIP){
			pMatchingIPClient = cur_client;
			++cMatches;
	}
	}
	if (pbMultipleIPs != NULL)
		*pbMultipleIPs = cMatches > 1;

	if (pMatchingIPClient != NULL && cMatches == 1)
		return pMatchingIPClient;
	else
		return NULL;
}

CUpDownClient* CUploadQueue::GetWaitingClientByIP(uint32 dwIP){
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;){
		CUpDownClient* cur_client = waitinglist.GetNext(pos);
		if (dwIP == cur_client->GetIP())
			return cur_client;
	}
	return 0;
}

/**
 * Add a client to the waiting queue for uploads.
 *
 * @param client address of the client that should be added to the waiting queue
 *
 * @param bIgnoreTimelimit don't check time limit to possibly ban the client.
 *
 * @param addInFirstPlace the client should be added first in queue, not last
 */
//==> dlarge SlotControl
void CUploadQueue::AddClientToQueue(CUpDownClient* client, bool bIgnoreTimelimit,  bool addInFirstPlace)
{
    if(addInFirstPlace == false) 
    {
	//This is to keep users from abusing the limits we put on lowID callbacks.
	//1)Check if we are connected to any network and that we are a lowID.
	//(Although this check shouldn't matter as they wouldn't have found us..
	// But, maybe I'm missing something, so it's best to check as a precaution.)
	//2)Check if the user is connected to Kad. We do allow all Kad Callbacks.
	//3)Check if the user is in our download list or a friend..
	//We give these users a special pass as they are helping us..
	//4)Are we connected to a server? If we are, is the user on the same server?
	//TCP lowID callbacks are also allowed..
	//5)If the queue is very short, allow anyone in as we want to make sure
	//our upload is always used.
	if (theApp.IsConnected() 
		&& theApp.IsFirewalled()
		&& !client->GetKadPort()
		&& client->GetDownloadState() == DS_NONE 
		&& !client->IsFriend()
		&& theApp.serverconnect
		&& !theApp.serverconnect->IsLocalServer(client->GetServerIP(),client->GetServerPort())
		&& GetWaitingUserCount() > 50)
		return;
	client->AddAskedCount();
	client->SetLastUpRequest();
	if (!bIgnoreTimelimit)
		client->AddRequestCount(client->GetUploadFileID());


//==> dlarge Argos System (Xanatos)
	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)client->GetUploadFileID()); //moved up
	if(thePrefs.IsFileFakerDetection() && client->CheckFileRequest(reqfile))
		return;
//<== dlarge Argos System (Xanatos)
	if (client->IsBanned())
		return;

//>>> Spike2::L2HAC [enkeyDEV]
	client->SetLastL2HACExecution();
	if (!client->HasLowID() && client->GetL2HACSupport()) 
		client->EnableL2HAC(true);
//<<< Spike2::L2HAC [enkeyDEV]
	}
//<== dlarge SlotControl

	uint16 cSameIP = 0;
	// check for double
	POSITION pos1, pos2;
	for (pos1 = waitinglist.GetHeadPosition();( pos2 = pos1 ) != NULL;)
	{
		waitinglist.GetNext(pos1);
		CUpDownClient* cur_client= waitinglist.GetAt(pos2);
		if (cur_client == client)
		{	
            if (addInFirstPlace == false && client->m_bAddNextConnect && AcceptNewClient(client->m_bAddNextConnect)) //==> dlarge SlotControl
			{
				//Special care is given to lowID clients that missed their upload slot
				//due to the saving bandwidth on callbacks.
//==> dlarge Add next connect theft? (netfinity)
				if (client->credits && client->credits->GetCurrentIdentState(client->GetIP()) == IS_IDBADGUY)
					LogWarning(_T("Possible queue jump attempt: %s"), client->DbgGetClientInfo());
//<== dlarge Add next connect theft? (netfinity)
				if(thePrefs.GetLogUlDlEvents())
//==> dlarge UploadingProblemClient (Xman)
//					AddDebugLogLine(true, _T("Adding ****lowid when reconnecting. Client: %s"), client->DbgGetClientInfo());
					AddDebugLogLine(true, client->m_bUpIsProblematic ? _T("Adding ~~~problematic client (second change) on reconnect. Client: %s") : _T("Adding ****lowid when reconnecting. Client: %s"), client->DbgGetClientInfo());
//<== dlarge UploadingProblemClient (Xman)
				client->m_bAddNextConnect = false;
				RemoveFromWaitingQueue(client, true);
//==> dlarge UploadingProblemClient (Xman)
//				AddUpNextClient(_T("Adding ****lowid when reconnecting."), client);
				AddUpNextClient(client->m_bUpIsProblematic ? _T("Adding ~~~problematic client (second change) on reconnect.") : _T("Adding ****lowid when reconnecting."), client);
//<== dlarge UploadingProblemClient (Xman)
				return;
			}
			client->SendRankingInfo();
			theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(client);
			return;			
		}
		else if ( client->Compare(cur_client) ) 
		{
			theApp.clientlist->AddTrackClient(client); // in any case keep track of this client

			// another client with same ip:port or hash
			// this happens only in rare cases, because same userhash / ip:ports are assigned to the right client on connecting in most cases
			if (cur_client->credits != NULL && cur_client->credits->GetCurrentIdentState(cur_client->GetIP()) == IS_IDENTIFIED)
			{
				//cur_client has a valid secure hash, don't remove him
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false, GetResString(IDS_SAMEUSERHASH), client->GetUserName(), cur_client->GetUserName(), client->GetUserName());
				return;
			}
			if (client->credits != NULL && client->credits->GetCurrentIdentState(client->GetIP()) == IS_IDENTIFIED)
			{
				//client has a valid secure hash, add him remove other one
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false, GetResString(IDS_SAMEUSERHASH), client->GetUserName(), cur_client->GetUserName(), cur_client->GetUserName());
				waitinglist.GetAt(pos2)->ClearWaitStartTime(); //==> dlarge SUQWT
				RemoveFromWaitingQueue(pos2,true);
				if (!cur_client->socket)
				{
					if(cur_client->Disconnected(_T("AddClientToQueue - same userhash 1")))
						delete cur_client;
				}
			}
//==> dlarge Argos System (Xanatos)
				else if (thePrefs.IsArgosHashThiefDetection()){
				//cur_client has higher Trust, dont remove him
				if (theApp.argos->GetTrust(cur_client->GetConnectIP()) > theApp.argos->GetTrust(client->GetConnectIP())){
					theApp.argos->DoArgos(client->GetConnectIP(), AR_HASHTHIEF);
					return;
				} else if (theApp.argos->GetTrust(client->GetConnectIP()) > theApp.argos->GetTrust(cur_client->GetConnectIP())){
					theApp.argos->DoArgos(cur_client->GetConnectIP(), AR_HASHTHIEF);
					waitinglist.GetAt(pos2)->ClearWaitStartTime(); //==> dlarge SUQWT
					RemoveFromWaitingQueue(pos2,true);		
					if (!cur_client->socket && cur_client->Disconnected(_T("AddClientToQueue - Disconnected due tu Argos")))
							delete cur_client;
				} else {
					// remove both since we dont know who the bad on is
					theApp.argos->DoArgos(client->GetConnectIP(), AR_HASHTHIEF);
					theApp.argos->DoArgos(cur_client->GetConnectIP(), AR_HASHTHIEF);
					waitinglist.GetAt(pos2)->ClearWaitStartTime(); //==> dlarge SUQWT
					RemoveFromWaitingQueue(pos2,true);	
					if (!cur_client->socket && cur_client->Disconnected(_T("AddClientToQueue - Disconnected due tu Argos")))
							delete cur_client;
					return;
				}
			}
//<== dlarge Argos System (Xanatos)
			else
			{
				// remove both since we do not know who the bad one is
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false, GetResString(IDS_SAMEUSERHASH), client->GetUserName() ,cur_client->GetUserName(), _T("Both"));
				waitinglist.GetAt(pos2)->ClearWaitStartTime(); //==> dlarge SUQWT
				RemoveFromWaitingQueue(pos2,true);	
				if (!cur_client->socket)
				{
					if(cur_client->Disconnected(_T("AddClientToQueue - same userhash 2")))
						delete cur_client;
				}
				return;
			}
		}
		else if (client->GetIP() == cur_client->GetIP())
			++cSameIP; // same IP, different port, different userhash
	}
	if (cSameIP >= 3)
	{
		// do not accept more than 3 clients from the same IP
		if (thePrefs.GetVerbose())
			DEBUG_ONLY( AddDebugLogLine(false,_T("%s's (%s) request to enter the queue was rejected, because of too many clients with the same IP"), client->GetUserName(), ipstr(client->GetConnectIP())) );
		return;
	}
	else if (theApp.clientlist->GetClientsFromIP(client->GetIP()) >= 3)
	{
		if (thePrefs.GetVerbose())
			DEBUG_ONLY( AddDebugLogLine(false,_T("%s's (%s) request to enter the queue was rejected, because of too many clients with the same IP (found in TrackedClientsList)"), client->GetUserName(), ipstr(client->GetConnectIP())) );
		return;
	}
	// done

    if(addInFirstPlace == false) {  //==> dlarge SlotControl
	// statistic values // TODO: Maybe we should change this to count each request for a file only once and ignore reasks
	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)client->GetUploadFileID());
	if (reqfile)
		reqfile->statistic.AddRequest();

	// emule collection will bypass the queue
	if (reqfile != NULL && CCollection::HasCollectionExtention(reqfile->GetFileName()) && reqfile->GetFileSize() < (uint64)MAXPRIORITYCOLL_SIZE
		&& !client->IsDownloading() && client->socket != NULL && client->socket->IsConnected())
	{
		client->SetCollectionUploadSlot(true);
		RemoveFromWaitingQueue(client, true);
		AddUpNextClient(_T("Collection Priority Slot"), client);
	}
	else
		client->SetCollectionUploadSlot(false);

   // cap the list
    // the queue limit in prefs is only a soft limit. Hard limit is 25% higher, to let in powershare clients and other
    // high ranking clients after soft limit has been reached
//>>> WiZaRd::QueueSize FiX
	const UINT hardQueueLimit = thePrefs.GetQueueSize();
	UINT softQueueLimit = (UINT)(hardQueueLimit*0.8f);
	if(hardQueueLimit - softQueueLimit < 200)
		softQueueLimit = hardQueueLimit-200;
//<<< WiZaRd::QueueSize FiX

    // if soft queue limit has been reached, only let in high ranking clients
	if (!thePrefs.IsInfiniteQueueEnabled())//>>> shadow2004::InfiniteQueue [SLUGFILLER]
	{
    if ((uint32)waitinglist.GetCount() >= hardQueueLimit ||
        (uint32)waitinglist.GetCount() >= softQueueLimit && // soft queue limit is reached
        (client->IsFriend() && client->GetFriendSlot()) == false && // client is not a friend with friend slot
			!reqfile->IsPowerShared() && //>>> WiZaRd::PowerShare
			client->GetCombinedFilePrioAndCredit() < GetAverageCombinedFilePrioAndCredit()) // and client has lower credits/wants lower prio file than average client in queue
        // then block client from getting on queue
		return;
	}
	if (client->IsDownloading())
	{
//==> dlarge Argos System (Xanatos)
		if (thePrefs.CloseMaellaBackdoor()){
			//a downloading client can simply request an other file during downloading
			//this code checks the Up-Priority of the new request
                         CKnownFile* accfile = client->GetUploadingFile();
			if(theApp.sharedfiles->IsFilePtrInList(accfile) && reqfile != NULL && client->GetScore(false, true, true, reqfile) < client->GetScore(false, true, true, accfile)){
				if(thePrefs.GetLogUlDlEvents())
					AddDebugLogLine(false, _T("--> Upload session ended due wrong requested FileID (in AddClientToQueue) (client=%s, expected=%s, asked=%s)"), client->GetUserName(),accfile->GetFileName(), reqfile->GetFileName());
				RemoveFromUploadQueue(client, _T("wrong file"),true);
				client->SendOutOfPartReqsAndAddToWaitingQueue();
				if(thePrefs.CloseMaellaBackdoor() == TRUE)
					client->SetWaitStartTime(); //==> dlarge SUQWT
				return;
			}
		}
//<== dlarge Argos System (Xanatos)
		// he's already downloading and wants probably only another file
		if (thePrefs.GetDebugClientTCPLevel() > 0)
			DebugSend("OP__AcceptUploadReq", client);
		Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
		theStats.AddUpDataOverheadFileRequest(packet->size);
		client->socket->SendPacket(packet,true);
		return;
	}
}  //==> dlarge SlotControl

//==> dlarge SUQWT 
	if (client->Credits() != NULL)
		client->Credits()->SetSecWaitStartTime();
//<== dlarge SUQWT 

//>>> WiZaRd::Startup Flood Prevention
	//Requested by James R. Bath
	//http://forum.emule-project.net/index.php?showtopic=101181
/*
	if (waitinglist.IsEmpty() && ForceNewClient(true) && !theApp.argos->IsArgos(client->GetConnectIP())) //==> dlarge Argos System (Xanatos)
	{
		AddUpNextClient(_T("Direct add with empty queue."), client);
	}
	else
*/
//<<< WiZaRd::Startup Flood Prevention
	{
		waitinglist.AddTail(client);
		client->SetUploadState(US_ONUPLOADQUEUE);
		// Add client to waiting list. If addInFirstPlace is set, client should not have its waiting time resetted
		theApp.emuledlg->transferwnd->queuelistctrl.AddClient(client,(addInFirstPlace == false)); //==> dlarge SlotControl
//		theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
		theApp.emuledlg->transferwnd->ShowQueueCount();
		client->SendRankingInfo();
	}
}

float CUploadQueue::GetAverageCombinedFilePrioAndCredit() 
{
    DWORD curTick = ::GetTickCount();
    if (curTick - m_dwLastCalculatedAverageCombinedFilePrioAndCredit > 5*1000) 
	{
        m_dwLastCalculatedAverageCombinedFilePrioAndCredit = curTick;

        // TODO: is there a risk of overflow? I don't think so...
        double sum = 0;
	    for (POSITION pos = waitinglist.GetHeadPosition(); pos != NULL; /**/)
		{
		    CUpDownClient* cur_client =	waitinglist.GetNext(pos);
            sum += cur_client->GetCombinedFilePrioAndCredit();
        }
        m_fAverageCombinedFilePrioAndCredit = (float)(sum/waitinglist.GetSize());
    }

    return m_fAverageCombinedFilePrioAndCredit;
}

bool CUploadQueue::RemoveFromUploadQueue(CUpDownClient* client, LPCTSTR pszReason, bool updatewindow, bool earlyabort){
    bool result = false;
    uint32 slotCounter = 1;
//>>> WiZaRd::Payback First
	POSITION findPos = m_lPaybackList.Find(client);
	if(findPos)
		m_lPaybackList.RemoveAt(findPos);
//<<< WiZaRd::Payback First
	for (POSITION pos = uploadinglist.GetHeadPosition();pos != 0;)
	{
        POSITION curPos = pos;
        CUpDownClient* curClient = uploadinglist.GetNext(pos);
		if (client == curClient)
		{
			if (updatewindow)
				theApp.emuledlg->transferwnd->uploadlistctrl.RemoveClient(client);

			if (thePrefs.GetLogUlDlEvents())
                AddDebugLogLine(DLP_DEFAULT, true,_T("Removing client from upload list: %s Client: %s Transferred: %s SessionUp: %s QueueSessionPayload: %s In buffer: %s Req blocks: %i File: %s"), pszReason==NULL ? _T("") : pszReason, client->DbgGetClientInfo(), CastSecondsToHM( client->GetUpStartTimeDelay()/1000), CastItoXBytes(client->GetSessionUp(), false, false), CastItoXBytes(client->GetQueueSessionPayloadUp(), false, false), CastItoXBytes(client->GetPayloadInBuffer()), client->GetNumberOfRequestedBlocksInQueue(), (theApp.sharedfiles->GetFileByID(client->GetUploadFileID())?theApp.sharedfiles->GetFileByID(client->GetUploadFileID())->GetFileName():_T("")));
            client->m_bAddNextConnect = false;
			uploadinglist.RemoveAt(curPos);

			client->UnscheduleForRemoval(); //==> dlarge SlotControl

            bool removed = theApp.uploadBandwidthThrottler->RemoveFromStandardList(client->socket);
            bool pcRemoved = theApp.uploadBandwidthThrottler->RemoveFromStandardList((CClientReqSocket*)client->m_pPCUpSocket);
			(void)removed;
			(void)pcRemoved;
            //if(thePrefs.GetLogUlDlEvents() && !(removed || pcRemoved)) {
            //    AddDebugLogLine(false, _T("UploadQueue: Didn't find socket to delete. Adress: 0x%x"), client->socket);
            //}

			if(client->GetSessionUp() > 0) 
			{
				++successfullupcount;
				totaluploadtime += client->GetUpStartTimeDelay()/1000;
            }
			else if(earlyabort == false)
				++failedupcount;

            CKnownFile* requestedFile = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());
            if(requestedFile != NULL) {
                requestedFile->UpdatePartsInfo();
            }
			theApp.clientlist->AddTrackClient(client); // Keep track of this client
			client->SetUploadState(US_NONE);
			client->ClearUploadBlockRequests();
			client->SetCollectionUploadSlot(false);

            m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = 0;

//==> dlarge SUQWT  
			if (client->Credits()!=NULL) {
				/* // no need to check this since the call is commented anyways
				if(earlyabort == true)
				{
				//client->Credits()->SaveUploadQueueWaitTime();
				}
				else*/
				if(client->GetSessionUp() < SESSIONMAXTRANS){
					int keeppct = (int)((100 - (100 * client->GetSessionUp()/SESSIONMAXTRANS)) - 10);// At least 10% time credit 'penalty'
					if (keeppct < 0)    keeppct = 0;
					client->Credits()->SaveUploadQueueWaitTime(keeppct);
					client->Credits()->SetSecWaitStartTime();
				} else {
					client->Credits()->ClearUploadQueueWaitTime();
					client->Credits()->ClearWaitStartTime();
				}
			}
//<== dlarge SUQWT 

			client->SetUploadingFile(NULL); //==> dlarge Argos System (Xanatos)

			result = true;
        }
		else 
		{
            curClient->SetSlotNumber(slotCounter);
            ++slotCounter;
        }
	}
	return result;
}

uint32 CUploadQueue::GetAverageUpTime(){
	if( successfullupcount ){
		return totaluploadtime/successfullupcount;
	}
	return 0;
}

bool CUploadQueue::RemoveFromWaitingQueue(CUpDownClient* client, bool updatewindow){
	POSITION pos = waitinglist.Find(client);
	if (pos){
		RemoveFromWaitingQueue(pos,updatewindow);
		return true;
	}
	else
		return false;
}

void CUploadQueue::RemoveFromWaitingQueue(POSITION pos, bool updatewindow){	
	CUpDownClient* todelete = waitinglist.GetAt(pos);
	waitinglist.RemoveAt(pos);
	if (updatewindow)
	{
		theApp.emuledlg->transferwnd->queuelistctrl.RemoveClient(todelete);
//>>> WiZaRd::FiX
	      //theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
		theApp.emuledlg->transferwnd->ShowQueueCount();
//<<< WiZaRd::FiX
	}
	todelete->m_bAddNextConnect = false; 
	todelete->SetUploadState(US_NONE);
//==> dlarge SUQWT  
	if (theApp.clientcredits->IsSaveUploadQueueWaitTime())
		todelete->Credits()->SaveUploadQueueWaitTime();
//<== dlarge SUQWT  
}

void CUploadQueue::UpdateMaxClientScore()
{
	m_imaxscore=0;
	for(POSITION pos = waitinglist.GetHeadPosition(); pos != 0; ) {
//==> dlarge UploadingProblemClient (Xman) 
		/*
		uint32 score = waitinglist.GetNext(pos)->GetScore(true, false);
		*/
		CUpDownClient* cur_client = waitinglist.GetNext(pos);
		uint32 score = cur_client->GetScore(true, false);

		if(score > m_imaxscore && !cur_client->m_bUpIsProblematic) 
//<== dlarge UploadingProblemClient (Xman)
			m_imaxscore=score;
	}
}

bool CUploadQueue::CheckForTimeOver(CUpDownClient* client){
// VQB: fullChunk
	//If we have nobody in the queue, do NOT remove the current uploads..
	//This will save some bandwidth and some unneeded swapping from upload/queue/upload..
	if ( waitinglist.IsEmpty() )
		return false;

	if(/*!client->GetFriendSlot() && */client->GetRemainingUp()+client->GetPayloadInBuffer() <= 0) 	// VQB: fullChunk
	{
		if (thePrefs.GetLogUlDlEvents())
			AddDebugLogLine(DLP_DEFAULT, false, _T("%s: Upload session ended due to max transferred amount - uploaded: %s"), client->GetUserName(), CastItoXBytes(client->GetSessionUp(), false, false));
		return true;
	}
// VQB: fullChunk
	return false;
}

void CUploadQueue::DeleteAll(){
	waitinglist.RemoveAll();
	uploadinglist.RemoveAll();
    // PENDING: Remove from UploadBandwidthThrottler as well!
}

UINT CUploadQueue::GetWaitingPosition(CUpDownClient* client)
{
	if (!IsOnUploadQueue(client))
		return 0;
	UINT rank = 1;
	UINT myscore = client->GetScore(false);
	bool bPSCheck = client->IsPowerShared(); //>>> WiZaRd::PowerShare
	for (POSITION pos = waitinglist.GetHeadPosition(); pos != 0; )
	{
//>>> WiZaRd::PowerShare
		CUpDownClient* cur_src = waitinglist.GetNext(pos);
		if((!bPSCheck || cur_src->IsPowerShared())
			&& cur_src->GetScore(false) > myscore)
		//if (waitinglist.GetNext(pos)->GetScore(false) > myscore)
//<<< WiZaRd::PowerShare
			++rank;
	}
	return rank;
}

VOID CALLBACK CUploadQueue::UploadTimer(HWND /*hwnd*/, UINT /*uMsg*/, UINT_PTR /*idEvent*/, DWORD /*dwTime*/)
{
	// NOTE: Always handle all type of MFC exceptions in TimerProcs - otherwise we'll get mem leaks
	try
	{
		// Barry - Don't do anything if the app is shutting down - can cause unhandled exceptions
		if (!theApp.emuledlg->IsRunning())
			return;

		const DWORD curTick = ::GetTickCount(); //cache it...

		// ZZ:UploadSpeedSense -->	
		theApp.lastCommonRouteFinder->SetPrefs(thePrefs.IsDynUpEnabled(),
                	theApp.uploadqueue->GetDatarate(), 
			thePrefs.GetMinUpload()*1024, 
			(thePrefs.IsSUCDoesWork())?theApp.uploadqueue->GetMaxVUR():(thePrefs.GetMaxUpload() != 0)?thePrefs.GetMaxUpload()*1024:thePrefs.GetMaxGraphUploadRate(true)*1024, //==> dlarge SUC/USS
			thePrefs.IsDynUpUseMillisecondPingTolerance(), 
			(thePrefs.GetDynUpPingTolerance() > 100) ? ((thePrefs.GetDynUpPingTolerance() - 100) / 100.0f) : 0, 
			thePrefs.GetDynUpPingToleranceMilliseconds(), 
			thePrefs.GetDynUpGoingUpDivider(), 
			thePrefs.GetDynUpGoingDownDivider(), 
			thePrefs.GetDynUpNumberOfPings(), 
			5,  // PENDING: Hard coded min pLowestPingAllowed
			thePrefs.IsUSSLog(), //==> dlarge SUC/USS
			thePrefs.IsUSSUDP()); //==> dlarge SUC/USS
		// ZZ:UploadSpeedSense <--

        theApp.uploadqueue->Process();
		theApp.downloadqueue->Process();

//>>> Spike2::ConChecker [eWombat]
			theApp.conchecker.Process(curTick);
//<<< Spike2::ConChecker [eWombat]

	// BEGIN SLUGFILLER: SafeHash 
		if (theApp.emuledlg->status != 255)
			return;
	// END SLUGFILLER: SafeHash

        // Elandal:ThreadSafeLogging -->
        // other threads may have queued up log lines. This prints them.
			theApp.HandleLogQueues();
//			theApp.HandleDebugLogQueue();
//			theApp.HandleLogQueue();			
        // Elandal: ThreadSafeLogging <--

			if (thePrefs.ShowOverhead())
                        {
			theStats.CompUpDatarateOverhead();
			theStats.CompDownDatarateOverhead();
		}
		++counter;

//==> dlarge Speedgraph (Xanatos)
		if (counter%5 == 0)
			theApp.emuledlg->Update_TrafficGraph();
//<== dlarge Speedgraph (Xanatos)

		// one second
		if (counter >= 10)
                {
			counter=0;

			// try to use different time intervals here to not create any disk-IO bottle necks by saving all files at once
			theApp.clientcredits->Process();	// 13 minutes
			theApp.serverlist->Process();		// 17 minutes
			theApp.knownfiles->Process();		// 11 minutes
			theApp.friendlist->Process();		// 19 minutes
//==> dlarge Argos System (Xanatos)
			if(thePrefs.UseArgosSystem())
				theApp.argos->Process();
//<== dlarge Argos System (Xanatos)
			theApp.clientlist->Process();
			theApp.sharedfiles->Process();
			if( Kademlia::CKademlia::IsRunning() )
			{
				Kademlia::CKademlia::Process();
				if(Kademlia::CKademlia::GetPrefs()->HasLostConnection())
				{
					Kademlia::CKademlia::Stop();
					theApp.emuledlg->ShowConnectionState();
				}
			}
			if( theApp.serverconnect->IsConnecting() && !theApp.serverconnect->IsSingleConnect() )
				theApp.serverconnect->TryAnotherConnectionRequest();

			theApp.listensocket->UpdateConnectionsStatus();
			if (thePrefs.WatchClipboard4ED2KLinks())
			{
				// TODO: Remove this from here. This has to be done with a clipboard chain
				// and *not* with a timer!!
				theApp.SearchClipboard();
			}

			if (theApp.serverconnect->IsConnecting())
				theApp.serverconnect->CheckForTimeout();

			// -khaos--+++> Update connection stats...
			++iupdateconnstats;
			// 2 seconds
			if (iupdateconnstats>=2) 
			{
				iupdateconnstats=0;
				theStats.UpdateConnectionStats((float)theApp.uploadqueue->GetDatarate()/1024, (float)theApp.downloadqueue->GetDatarate()/1024);
			}
			// <-----khaos-

			if (thePrefs.IsMiniMuleEnabled() && theApp.minimule != NULL && (theApp.minimule->IsWindowVisible() || thePrefs.GetMiniMuleLives())) theApp.minimule->RunMiniMule();  //==> dlarge minimule 

			// display graphs
			if (thePrefs.GetTrafficOMeterInterval()>0) 
			{
				++igraph;

				if (igraph >= (uint32)(thePrefs.GetTrafficOMeterInterval()) ) 
				{
					igraph=0;
					//theApp.emuledlg->statisticswnd->SetCurrentRate((float)(theApp.uploadqueue->Getavgupload()/theApp.uploadqueue->Getavg())/1024,(float)(theApp.uploadqueue->Getavgdownload()/theApp.uploadqueue->Getavg())/1024);
					theApp.emuledlg->statisticswnd->SetCurrentRate((float)(theApp.uploadqueue->GetDatarate())/1024,(float)(theApp.downloadqueue->GetDatarate())/1024);
					//theApp.uploadqueue->Zeroavg();
				}
			}
			if (theApp.emuledlg->activewnd == theApp.emuledlg->statisticswnd && theApp.emuledlg->IsWindowVisible() )  
			{
				// display stats
				if (thePrefs.GetStatsInterval()>0) 
				{
					++istats;

					if (istats >= (uint32)(thePrefs.GetStatsInterval()) ) 
					{
						istats=0;
						theApp.emuledlg->statisticswnd->ShowStatistics();
					}
				}
			}

            theApp.uploadqueue->UpdateDatarates();
            
            //save rates every second
			theStats.RecordRate();
			// mobilemule sockets
			theApp.mmserver->Process();

			// ZZ:UploadSpeedSense -->
            theApp.emuledlg->ShowPing();

            if(!theApp.clientlist->GiveClientsForTraceRoute())
                theApp.serverlist->GiveServersForTraceRoute();
			// ZZ:UploadSpeedSense <--

			if (theApp.emuledlg->IsTrayIconToFlash())
				theApp.emuledlg->ShowTransferRate(true);

            ++sec;
			// *** 5 seconds **********************************************
			if (sec>=5) 
                        {
#ifdef _DEBUG
				if (thePrefs.m_iDbgHeap > 0 && !AfxCheckMemory())
					AfxDebugBreak();
#endif

				sec = 0;
				theApp.listensocket->Process();
				if(thePrefs.IsOnlineSignatureEnabled()) theApp.OnlineSig(); //==> dlarge Code Optimation
				if (!theApp.emuledlg->IsTrayIconToFlash())
					theApp.emuledlg->ShowTransferRate();
				thePrefs.EstimateMaxUploadCap(theApp.uploadqueue->GetDatarate()/1024);
				
//>>> WiZaRd::Automatic Firewalled Retries
				//15 retries = 30 mins! 				
				#define MAX_FIREWALLED_RETRIES	15
				if(curTick - m_dwFirewalledTimer > MIN2MS(2))
				{
					m_dwFirewalledTimer = curTick;
					if(Kademlia::CKademlia::IsConnected() && Kademlia::CKademlia::IsFirewalled())
					{
						if(m_iFirewalledRetries < MAX_FIREWALLED_RETRIES)
						{
							++m_iFirewalledRetries;
							theApp.QueueLogLineEx(LOG_WARNING, L"Rechecking firewalled status - try %u out of %u...", m_iFirewalledRetries, MAX_FIREWALLED_RETRIES);
							// Refresh der Portmappings ? [shadow2004]
							// some routers seems to loose the settings after a while
								Kademlia::CKademlia::RecheckFirewalled();
							}
						else if(m_iFirewalledRetries == MAX_FIREWALLED_RETRIES)
						{
							++m_iFirewalledRetries;
							theApp.QueueLogLineEx(LOG_ERROR, L"Rechecking firewalled status failed %u times - stopping checks...", MAX_FIREWALLED_RETRIES);
						}
					}
					else
						m_iFirewalledRetries = 0;
				}
//<<< WiZaRd::Automatic Firewalled Retries

// VQB: fullChunk
				/*
				if (!thePrefs.TransferFullChunks())
					theApp.uploadqueue->UpdateMaxClientScore();
				*/
// VQB: fullChunk
				// update cat-titles with downloadinfos only when needed
				if (thePrefs.ShowCatTabInfos() && 
					theApp.emuledlg->activewnd == theApp.emuledlg->transferwnd && 
					theApp.emuledlg->IsWindowVisible()) 
						theApp.emuledlg->transferwnd->UpdateCatTabTitles(false);
				
				if (thePrefs.IsSchedulerEnabled())
					theApp.scheduler->Check();

//				theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2Uploading, -1);
				theApp.emuledlg->transferwnd->UpdateListCount(wnd2Uploading);
			}

			++statsave;
			// *** 60 seconds *********************************************
			if (statsave >= 60) 
                        {
				statsave=0;

				if (thePrefs.GetWSIsEnabled())
					theApp.webserver->UpdateSessionCount();

				theApp.serverconnect->KeepConnectionAlive();

				if (thePrefs.GetPreventStandby())
					theApp.ResetStandByIdleTimer(); // Reset Windows idle standby timer if necessary
			}

			++_uSaveStatistics;
			if (_uSaveStatistics >= thePrefs.GetStatsSaveInterval())
			{
				_uSaveStatistics = 0;
				thePrefs.SaveStats();
			}
		}

		// need more accuracy here. don't rely on the 'sec' and 'statsave' helpers.
		thePerfLog.LogSamples();
	}
	CATCH_DFLT_EXCEPTIONS(_T("CUploadQueue::UploadTimer"))
}

CUpDownClient* CUploadQueue::GetNextClient(const CUpDownClient* lastclient){
	if (waitinglist.IsEmpty())
		return 0;
	if (!lastclient)
		return waitinglist.GetHead();
	POSITION pos = waitinglist.Find(const_cast<CUpDownClient*>(lastclient));
	if (!pos){
		TRACE("Error: CUploadQueue::GetNextClient");
		return waitinglist.GetHead();
	}
	waitinglist.GetNext(pos);
	if (!pos)
		return NULL;
	else
		return waitinglist.GetAt(pos);
}

void CUploadQueue::UpdateDatarates() {
    // Calculate average datarate
    if(::GetTickCount()-m_lastCalculatedDataRateTick > 500) {
        m_lastCalculatedDataRateTick = ::GetTickCount();

        if(avarage_dr_list.GetSize() >= 2 && (avarage_tick_list.GetTail() > avarage_tick_list.GetHead())) {
	        datarate = (UINT)(((m_avarage_dr_sum - avarage_dr_list.GetHead())*1000) / (avarage_tick_list.GetTail() - avarage_tick_list.GetHead()));
            friendDatarate = (UINT)(((avarage_friend_dr_list.GetTail() - avarage_friend_dr_list.GetHead())*1000) / (avarage_tick_list.GetTail() - avarage_tick_list.GetHead()));
        }
    }
}

uint32 CUploadQueue::GetDatarate() {
    return datarate;
}

uint32 CUploadQueue::GetToNetworkDatarate() {
    if(datarate > friendDatarate) {
        return datarate - friendDatarate;
    } else {
        return 0;
    }
}

void CUploadQueue::ReSortUploadSlots(bool force) {
    DWORD curtick = ::GetTickCount();
    if(force ||  curtick - m_dwLastResortedUploadSlots >= 10*1000) {
        m_dwLastResortedUploadSlots = curtick;

        theApp.uploadBandwidthThrottler->Pause(true);

    	CTypedPtrList<CPtrList, CUpDownClient*> tempUploadinglist;

        // Remove all clients from uploading list and store in tempList
        POSITION ulpos = uploadinglist.GetHeadPosition();
        while (ulpos != NULL) {
            POSITION curpos = ulpos;
            uploadinglist.GetNext(ulpos);

            // Get and remove the client from upload list.
		    CUpDownClient* cur_client = uploadinglist.GetAt(curpos);

            uploadinglist.RemoveAt(curpos);

            // Remove the found Client from UploadBandwidthThrottler
            theApp.uploadBandwidthThrottler->RemoveFromStandardList(cur_client->socket);
            theApp.uploadBandwidthThrottler->RemoveFromStandardList((CClientReqSocket*)cur_client->m_pPCUpSocket);

            tempUploadinglist.AddTail(cur_client);
        }

        // Remove one at a time from temp list and reinsert in correct position in uploading list
        POSITION tempPos = tempUploadinglist.GetHeadPosition();
        while(tempPos != NULL) {
            POSITION curpos = tempPos;
            tempUploadinglist.GetNext(tempPos);

            // Get and remove the client from upload list.
		    CUpDownClient* cur_client = tempUploadinglist.GetAt(curpos);

            tempUploadinglist.RemoveAt(curpos);

            // This will insert in correct place
            InsertInUploadingList(cur_client);
        }

        theApp.uploadBandwidthThrottler->Pause(false);
    }
}

// VQB: fullChunk
void CUploadQueue::UpdateRemainingUp()
{
	for(POSITION pos = uploadinglist.GetHeadPosition(); pos;)
		uploadinglist.GetNext(pos)->UpdateRemainingUp();
}
// VQB: fullChunk

//==> dlarge SUC/USS
uint32	CUploadQueue::GetMaxVUR()
{
	return min(max(MaxVUR,(uint32)1024*thePrefs.GetMinUpload()),(uint32)1024*thePrefs.GetMaxUpload());
}
//<== dlarge SUC/USS

//==> dlarge UploadingProblemClient (Xman)
void CUploadQueue::AddClientDirectToQueue(CUpDownClient* client)
{
	if(CKnownFile* reqfile = theApp.sharedfiles->GetFileByID(client->GetUploadFileID())){
		theApp.uploadqueue->waitinglist.AddTail(client);
		client->SetUploadState(US_ONUPLOADQUEUE);
		client->m_bAddNextConnect = true;
		theApp.emuledlg->transferwnd->queuelistctrl.AddClient(client,false);
		theApp.emuledlg->transferwnd->ShowQueueCount();
	}
}
//<== dlarge UploadingProblemClient (Xman)

//==> dlarge SlotControl
uint32 CUploadQueue::GetWantedNumberOfTrickleUploads() {
    uint32 minNumber = MINNUMBEROFTRICKLEUPLOADS;

    if(minNumber < 1 && GetDatarate() >= 2*1024) {
        minNumber = 1;
    }

    return max((uint32)(GetEffectiveUploadListCount()*0.1), minNumber);
}

uint32 CUploadQueue::GetEffectiveUploadListCount() {
    uint32 count = 0;

	POSITION pos = uploadinglist.GetTailPosition();

	while(pos != NULL){
        // Get the client. Note! Also updates pos as a side effect.
		CUpDownClient* cur_client = uploadinglist.GetPrev(pos);

		if(!cur_client->IsScheduledForRemoval()) {
			pos = NULL;
        }
		else
		{
            count++;
        }
	}

    return uploadinglist.GetCount()-count;
}

void CUploadQueue::ScheduleRemovalFromUploadQueue(CUpDownClient* client, LPCTSTR pszDebugReason, CString strDisplayReason, bool earlyabort) {
	if (thePrefs.GetLogUlDlEvents())
        AddDebugLogLine(DLP_VERYLOW, true,_T("Scheduling to remove client from upload list: %s Client: %s Transfered: %s SessionUp: %s QueueSessionPayload: %s"), pszDebugReason==NULL ? _T("") : pszDebugReason, client->DbgGetClientInfo(), CastSecondsToHM( client->GetUpStartTimeDelay()/1000), CastItoXBytes(client->GetSessionUp(), false, false), CastItoXBytes(client->GetQueueSessionPayloadUp(), false, false));

    client->ScheduleRemovalFromUploadQueue(pszDebugReason, strDisplayReason, earlyabort);
	MoveDownInUploadQueue(client);

    m_nLastStartUpload = ::GetTickCount();
}

void CUploadQueue::MoveDownInUploadQueue(CUpDownClient* client) {
    // first find the client in the uploadinglist
    uint32 posCounter = 0;
    POSITION foundPos = NULL;
    POSITION pos = uploadinglist.GetHeadPosition();
	while(pos != NULL && foundPos == NULL)
	{
		if (uploadinglist.GetAt(pos) == client)
		{
            foundPos = pos;
        }
		else
		{
            uploadinglist.GetNext(pos);
            posCounter++;
        }
	}

    if(foundPos != NULL)
	{
        // Remove the found Client
		uploadinglist.RemoveAt(foundPos);
        theApp.uploadBandwidthThrottler->RemoveFromStandardList(client->socket);

        // then add it last in it's class
        InsertInUploadingList(client);
    }
}
//<== dlarge SlotControl